/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.IPAddress;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEvent;

public abstract class DHCPClientProcessEvent
extends IPCEvent {
    public EventType type;

    public DHCPClientProcessEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        DHCP_SUCCEED,
        DHCP_CONFIGURED,
        DHCP_FAILED;

    }

    public static class DhcpFailed
    extends DHCPClientProcessEvent {
        public String deviceName;
        public String portName;

        public DhcpFailed(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.DHCP_FAILED;
            this.deviceName = (String)ltv.getEventParameters().get(0);
            this.portName = (String)ltv.getEventParameters().get(1);
        }

        public String toString() {
            return super.toString() + "\n\tdeviceName = " + this.deviceName + "\n\tportName = " + this.portName;
        }
    }

    public static class DhcpConfigured
    extends DHCPClientProcessEvent {
        public String deviceName;
        public String portName;
        public Boolean isConfigured;

        public DhcpConfigured(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.DHCP_CONFIGURED;
            this.deviceName = (String)ltv.getEventParameters().get(0);
            this.portName = (String)ltv.getEventParameters().get(1);
            this.isConfigured = (Boolean)ltv.getEventParameters().get(2);
        }

        public String toString() {
            return super.toString() + "\n\tdeviceName = " + this.deviceName + "\n\tportName = " + this.portName + "\n\tisConfigured = " + this.isConfigured;
        }
    }

    public static class DhcpSucceed
    extends DHCPClientProcessEvent {
        public String deviceName;
        public String portName;
        public IPAddress newip;
        public IPAddress newmask;

        public DhcpSucceed(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.DHCP_SUCCEED;
            this.deviceName = (String)ltv.getEventParameters().get(0);
            this.portName = (String)ltv.getEventParameters().get(1);
            this.newip = (IPAddress)ltv.getEventParameters().get(2);
            this.newmask = (IPAddress)ltv.getEventParameters().get(3);
        }

        public String toString() {
            return super.toString() + "\n\tdeviceName = " + this.deviceName + "\n\tportName = " + this.portName + "\n\tnewip = " + this.newip + "\n\tnewmask = " + this.newmask;
        }
    }
}

